function [x,data,k] = Projected_Grad_Desc(objfun,Q,h,A,b,x0)

% Parameters
MAXITER   = 15;
% fixed step size
alpha = .5;

% save iterate information
data    = [];
data.x0 = x0;
data.x  = []; % iterates
data.d  = []; % search directions
data.g  = []; % gradients

% initial iterate should be feasible
xk = pg(x0,A,b);

% print the header
printIter();

tic
for k = 1:MAXITER
    
    % compute function and gradient
    [f_k,g_k] = objfun(xk);

    
    % compute search direction (projected steepest descent)
    d_k = pg(xk-g_k,A,b)-xk;
    
    xk1 = xk+alpha*d_k;
    
    
    % record the iterates
    if nargout >= 2
        data.x = [data.x,xk];
        data.d = [data.d,d_k];
        data.g = [data.g,g_k];
    end
    
    % update iterate
    xk = xk1;
    
    % print progress
    printIter(k, f_k, norm(d_k), alpha, toc);
    
    
end

x = xk;


end

%projection function
function x = pg(y,A,b)

n = length(y);
H = eye(n);
x0 = y;
options = optimset('Display','off');
x = quadprog(H,-y,A,b,[],[],[],[],x0,options);

end


function printIter(iter, f_k, d_k_norm, alpha_k, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '  k        f        ||d||        alpha       CPU (s)';

% print algorithm output header
fprintf('\nBeginning gradient descent ...\n')
fprintf('%s\n%s\n%s\n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e  % .4e   % .5f\n',iter, f_k, d_k_norm, alpha_k, CPUtime);



end
